# Схема с последовательностью выполняемых операций IT-продукта
## Персонализированные дидактические материалы для адаптивного корпоративного обучения

```mermaid
sequenceDiagram
    participant User as Сотрудник
    participant Platform as Платформа e-learning
    participant Content as Персонализированный контент
    participant Analytics as Система аналитики
    participant Admin as Администратор / HR

    User->>Platform: Вход в систему
    Platform->>Content: Запрос персонализированных модулей
    Content-->>Platform: Передача адаптивного учебного контента
    Platform->>User: Отображение дашборда и рекомендованных модулей
    User->>Content: Выполнение уроков и интерактивных заданий
    Content-->>Analytics: Отправка результатов и прогресса
    Analytics-->>Platform: Формирование отчётов и обновление траекторий
    Platform->>User: Обновление прогресса и рекомендации по обучению
    Admin->>Analytics: Мониторинг эффективности и корректировка курсов
    Analytics-->>Admin: Отчёты и статистика персонализированного обучения
````

### Описание схемы

* **User** — сотрудник компании, проходящий обучение.
* **Platform** — IT-продукт, обеспечивающий адаптивное взаимодействие.
* **Content** — база персонализированных дидактических материалов.
* **Analytics** — система сбора и анализа прогресса, формирующая отчёты.
* **Admin / HR** — администратор или HR-специалист, контролирующий эффективность обучения.

Схема показывает поток данных и действий: пользователь получает персонализированный контент, выполняет задания, система фиксирует результаты и обновляет траекторию обучения, а администратор получает отчёты для мониторинга и улучшения программы.
